/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.IConfigurable;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.basic.BasicCapabilityResolver;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityFluidicPlenisher
extends TileEntityMekanism
implements IConfigurable {
    private static final EnumSet<Direction> dirs = EnumSet.complementOf(EnumSet.of(Direction.UP));
    public static final int BASE_TICKS_REQUIRED = 20;
    private final Set<BlockPos> activeNodes = new ObjectLinkedOpenHashSet();
    private final Set<BlockPos> usedNodes = new ObjectOpenHashSet();
    public boolean finishedCalc;
    public int ticksRequired = 20;
    public int operatingTicks;
    private MachineEnergyContainer<TileEntityFluidicPlenisher> energyContainer;
    public BasicFluidTank fluidTank;
    private FluidInventorySlot inputSlot;
    private OutputInventorySlot outputSlot;
    private EnergyInventorySlot energySlot;

    public TileEntityFluidicPlenisher() {
        super(MekanismBlocks.FLUIDIC_PLENISHER);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIGURABLE_CAPABILITY, this));
    }

    @Override
    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        FluidTankHelper builder = FluidTankHelper.forSide(this::getDirection);
        this.fluidTank = BasicFluidTank.input(10000, this::isValidFluid, this);
        builder.addTank(this.fluidTank, RelativeSide.TOP);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer, RelativeSide.BACK);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.inputSlot = FluidInventorySlot.fill(this.fluidTank, this, 28, 20);
        builder.addSlot(this.inputSlot, RelativeSide.TOP);
        this.outputSlot = OutputInventorySlot.at(this, 28, 51);
        builder.addSlot(this.outputSlot, RelativeSide.BOTTOM);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityFluidicPlenisher)this).func_145831_w(), this, 143, 35);
        builder.addSlot(this.energySlot, RelativeSide.BACK);
        return builder.build();
    }

    private boolean isValidFluid(@Nonnull FluidStack stack) {
        return stack.getFluid().getAttributes().canBePlacedInWorld((IBlockDisplayReader)this.func_145831_w(), this.field_174879_c.func_177977_b(), stack);
    }

    @Override
    protected void onUpdateServer() {
        FloatingLong energyPerTick;
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.inputSlot.fillTank(this.outputSlot);
        if (MekanismUtils.canFunction(this) && !this.fluidTank.isEmpty() && this.energyContainer.extract(energyPerTick = this.energyContainer.getEnergyPerTick(), Action.SIMULATE, AutomationType.INTERNAL).equals(energyPerTick)) {
            if (!this.finishedCalc) {
                this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
            }
            ++this.operatingTicks;
            if (this.operatingTicks >= this.ticksRequired) {
                this.operatingTicks = 0;
                if (this.finishedCalc) {
                    BlockPos below = this.func_174877_v().func_177977_b();
                    if (this.canReplace(below, false, false) && this.canExtractBucket() && WorldUtils.tryPlaceContainedLiquid(null, this.field_145850_b, below, this.fluidTank.getFluid(), null)) {
                        this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
                        this.fluidTank.extract(1000, Action.EXECUTE, AutomationType.INTERNAL);
                    }
                } else {
                    this.doPlenish();
                }
            }
        }
    }

    private boolean canExtractBucket() {
        return this.fluidTank.extract(1000, Action.SIMULATE, AutomationType.INTERNAL).getAmount() == 1000;
    }

    private void doPlenish() {
        if (this.usedNodes.size() >= MekanismConfig.general.maxPlenisherNodes.get()) {
            this.finishedCalc = true;
            return;
        }
        if (this.activeNodes.isEmpty()) {
            if (this.usedNodes.isEmpty()) {
                BlockPos below = this.func_174877_v().func_177977_b();
                if (!this.canReplace(below, true, true)) {
                    this.finishedCalc = true;
                    return;
                }
                this.activeNodes.add(below);
            } else {
                this.finishedCalc = true;
                return;
            }
        }
        ObjectOpenHashSet toRemove = new ObjectOpenHashSet();
        for (BlockPos nodePos : this.activeNodes) {
            if (WorldUtils.isBlockLoaded((IBlockReader)this.field_145850_b, nodePos)) {
                if (this.canReplace(nodePos, true, false) && this.canExtractBucket() && WorldUtils.tryPlaceContainedLiquid(null, this.field_145850_b, nodePos, this.fluidTank.getFluid(), null)) {
                    this.fluidTank.extract(1000, Action.EXECUTE, AutomationType.INTERNAL);
                }
                for (Direction dir : dirs) {
                    BlockPos sidePos = nodePos.func_177972_a(dir);
                    if (!WorldUtils.isBlockLoaded((IBlockReader)this.field_145850_b, sidePos) || !this.canReplace(sidePos, true, true)) continue;
                    this.activeNodes.add(sidePos);
                }
                toRemove.add(nodePos);
                break;
            }
            toRemove.add(nodePos);
        }
        this.usedNodes.addAll((Collection<BlockPos>)toRemove);
        this.activeNodes.removeAll((Collection<?>)toRemove);
    }

    private boolean canReplace(BlockPos pos, boolean checkNodes, boolean isPathfinding) {
        if (checkNodes && this.usedNodes.contains(pos)) {
            return false;
        }
        BlockState state = this.field_145850_b.func_180495_p(pos);
        if (state.isAir((IBlockReader)this.field_145850_b, pos)) {
            return true;
        }
        FluidState currentFluidState = state.func_204520_s();
        if (!currentFluidState.func_206888_e()) {
            if (currentFluidState.func_206889_d()) {
                return isPathfinding;
            }
            return true;
        }
        FluidStack stack = this.fluidTank.getFluid();
        if (stack.isEmpty()) {
            return WorldUtils.isValidReplaceableBlock((IBlockReader)this.field_145850_b, pos) || state.func_177230_c() instanceof ILiquidContainer;
        }
        Fluid fluid = stack.getFluid();
        if (state.func_227032_a_(fluid)) {
            return true;
        }
        return state.func_177230_c() instanceof ILiquidContainer && ((ILiquidContainer)state.func_177230_c()).func_204510_a((IBlockReader)this.field_145850_b, pos, state, fluid);
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("progress", this.operatingTicks);
        nbtTags.func_74757_a("finished", this.finishedCalc);
        if (!this.activeNodes.isEmpty()) {
            ListNBT activeList = new ListNBT();
            for (BlockPos wrapper : this.activeNodes) {
                activeList.add((Object)NBTUtil.func_186859_a((BlockPos)wrapper));
            }
            nbtTags.func_218657_a("activeNodes", (INBT)activeList);
        }
        if (!this.usedNodes.isEmpty()) {
            ListNBT usedList = new ListNBT();
            for (BlockPos obj : this.usedNodes) {
                usedList.add((Object)NBTUtil.func_186859_a((BlockPos)obj));
            }
            nbtTags.func_218657_a("usedNodes", (INBT)usedList);
        }
        return nbtTags;
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbtTags) {
        int i;
        ListNBT tagList;
        super.func_230337_a_(state, nbtTags);
        this.operatingTicks = nbtTags.func_74762_e("progress");
        this.finishedCalc = nbtTags.func_74767_n("finished");
        if (nbtTags.func_150297_b("activeNodes", 9)) {
            tagList = nbtTags.func_150295_c("activeNodes", 10);
            for (i = 0; i < tagList.size(); ++i) {
                this.activeNodes.add(NBTUtil.func_186861_c((CompoundNBT)tagList.func_150305_b(i)));
            }
        }
        if (nbtTags.func_150297_b("usedNodes", 9)) {
            tagList = nbtTags.func_150295_c("usedNodes", 10);
            for (i = 0; i < tagList.size(); ++i) {
                this.usedNodes.add(NBTUtil.func_186861_c((CompoundNBT)tagList.func_150305_b(i)));
            }
        }
    }

    @Override
    public ActionResultType onSneakRightClick(PlayerEntity player, Direction side) {
        this.activeNodes.clear();
        this.usedNodes.clear();
        this.finishedCalc = false;
        player.func_145747_a((ITextComponent)MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, EnumColor.GRAY, MekanismLang.PLENISHER_RESET), Util.field_240973_b_);
        return ActionResultType.SUCCESS;
    }

    @Override
    public ActionResultType onRightClick(PlayerEntity player, Direction side) {
        return ActionResultType.PASS;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.ticksRequired = MekanismUtils.getTicks(this, 20);
        }
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.fluidTank.getFluidAmount(), this.fluidTank.getCapacity());
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(() -> this.finishedCalc, value -> {
            this.finishedCalc = value;
        }));
    }

    public MachineEnergyContainer<TileEntityFluidicPlenisher> getEnergyContainer() {
        return this.energyContainer;
    }
}

