/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.qio;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.content.qio.IQIODriveHolder;
import mekanism.common.content.qio.QIODriveData;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.slot.QIODriveSlot;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.qio.TileEntityQIOComponent;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class TileEntityQIODriveArray
extends TileEntityQIOComponent
implements IQIODriveHolder {
    public static final ModelProperty<byte[]> DRIVE_STATUS_PROPERTY = new ModelProperty();
    private static final int DRIVE_SLOTS = 12;
    private List<IInventorySlot> driveSlots;
    private byte[] driveStatus = new byte[12];
    private int prevDriveHash = -1;

    public TileEntityQIODriveArray() {
        super(MekanismBlocks.QIO_DRIVE_ARRAY);
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        int xSize = 176;
        this.driveSlots = new ArrayList<IInventorySlot>();
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 6; ++x) {
                QIODriveSlot slot = new QIODriveSlot(this, y * 6 + x, 34 + x * 18, 70 + y * 18);
                this.driveSlots.add(slot);
                builder.addSlot(slot);
            }
        }
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            QIOFrequency frequency = this.getQIOFrequency();
            this.setActive(frequency != null);
            for (int i = 0; i < 12; ++i) {
                QIODriveData data;
                QIODriveSlot slot = (QIODriveSlot)this.driveSlots.get(i);
                QIODriveData qIODriveData = data = frequency != null ? frequency.getDriveData(slot.getKey()) : null;
                if (frequency == null || data == null) {
                    this.setDriveStatus(i, slot.getStack().func_190926_b() ? DriveStatus.NONE : DriveStatus.OFFLINE);
                    continue;
                }
                if (data.getTotalCount() == data.getCountCapacity()) {
                    this.setDriveStatus(i, DriveStatus.FULL);
                    continue;
                }
                if (data.getTotalTypes() == data.getTypeCapacity() || (double)data.getTotalCount() >= (double)data.getCountCapacity() * 0.75) {
                    this.setDriveStatus(i, DriveStatus.NEAR_FULL);
                    continue;
                }
                this.setDriveStatus(i, DriveStatus.READY);
            }
            int newHash = Arrays.hashCode(this.driveStatus);
            if (newHash != this.prevDriveHash) {
                this.sendUpdatePacket();
                this.prevDriveHash = newHash;
            }
        }
    }

    private void setDriveStatus(int slot, DriveStatus status) {
        this.driveStatus[slot] = (byte)status.ordinal();
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT tag) {
        QIOFrequency freq = (QIOFrequency)this.getFrequency(FrequencyType.QIO);
        if (freq != null) {
            freq.saveAll();
        }
        super.func_189515_b(tag);
        return tag;
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(DRIVE_STATUS_PROPERTY, (Object)this.driveStatus).build();
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_74773_a("drives", this.driveStatus);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.driveStatus = tag.func_74770_j("drives");
        this.requestModelDataUpdate();
        WorldUtils.updateBlock(this.func_145831_w(), this.func_174877_v());
    }

    @Override
    public void onDataUpdate() {
        this.markDirty(false);
    }

    @Override
    public List<IInventorySlot> getDriveSlots() {
        return this.driveSlots;
    }

    public static enum DriveStatus {
        NONE(null),
        OFFLINE(Mekanism.rl("block/qio_drive/qio_drive_offline")),
        READY(Mekanism.rl("block/qio_drive/qio_drive_empty")),
        NEAR_FULL(Mekanism.rl("block/qio_drive/qio_drive_partial")),
        FULL(Mekanism.rl("block/qio_drive/qio_drive_full"));

        private final ResourceLocation model;
        public static final DriveStatus[] STATUSES;

        private DriveStatus(ResourceLocation model) {
            this.model = model;
        }

        public int ledIndex() {
            return this.ordinal() - READY.ordinal();
        }

        public ResourceLocation getModel() {
            return this.model;
        }

        static {
            STATUSES = DriveStatus.values();
        }
    }
}

