/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.qio;

import javax.annotation.Nonnull;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableItemStack;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.qio.TileEntityQIOComponent;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class TileEntityQIORedstoneAdapter
extends TileEntityQIOComponent {
    public static final ModelProperty<Boolean> POWERING_PROPERTY = new ModelProperty();
    private boolean prevPowering;
    private HashedItem itemType = null;
    private long count = 0L;
    private long clientStoredCount = 0L;

    public TileEntityQIORedstoneAdapter() {
        super(MekanismBlocks.QIO_REDSTONE_ADAPTER);
    }

    public boolean isPowering() {
        if (this.isRemote()) {
            return this.prevPowering;
        }
        QIOFrequency freq = this.getQIOFrequency();
        if (freq != null && this.itemType != null) {
            long stored = freq.getStored(this.itemType);
            return stored > 0L && stored >= this.count;
        }
        return false;
    }

    public void handleStackChange(ItemStack stack) {
        this.itemType = stack.func_190926_b() ? null : new HashedItem(stack);
        this.markDirty(false);
    }

    public void handleCountChange(int count) {
        this.count = count;
        this.markDirty(false);
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        boolean powering = this.isPowering();
        if (powering != this.prevPowering) {
            World world = this.func_145831_w();
            if (world != null) {
                world.func_195593_d(this.func_174877_v(), this.getBlockType());
            }
            this.prevPowering = powering;
            this.sendUpdatePacket();
        }
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            QIOFrequency frequency = this.getQIOFrequency();
            this.setActive(frequency != null);
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(POWERING_PROPERTY, (Object)this.prevPowering).build();
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_74757_a("active", this.prevPowering);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.prevPowering = tag.func_74767_n("active");
        this.requestModelDataUpdate();
        WorldUtils.updateBlock(this.func_145831_w(), this.func_174877_v());
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbtTags) {
        super.func_230337_a_(state, nbtTags);
        NBTUtils.setItemStackIfPresent(nbtTags, "singleItem", item -> {
            this.itemType = new HashedItem((ItemStack)item);
        });
        NBTUtils.setLongIfPresent(nbtTags, "amount", value -> {
            this.count = value;
        });
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.itemType != null) {
            nbtTags.func_218657_a("singleItem", (INBT)this.itemType.getStack().func_77955_b(new CompoundNBT()));
        }
        nbtTags.func_74772_a("amount", this.count);
        return nbtTags;
    }

    public ItemStack getItemType() {
        return this.itemType != null ? this.itemType.getStack() : ItemStack.field_190927_a;
    }

    public long getCount() {
        return this.count;
    }

    public long getStoredCount() {
        return this.clientStoredCount;
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableItemStack.create(this::getItemType, value -> {
            this.itemType = value.func_190926_b() ? null : new HashedItem((ItemStack)value);
        }));
        container.track(SyncableLong.create(this::getCount, value -> {
            this.count = value;
        }));
        container.track(SyncableLong.create(() -> {
            QIOFrequency freq = this.getQIOFrequency();
            return freq != null && this.itemType != null ? freq.getStored(this.itemType) : 0L;
        }, value -> {
            this.clientStoredCount = value;
        }));
    }
}

