/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import javax.annotation.Nonnull;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.tier.BaseTier;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.capabilities.proxy.ProxyFluidHandler;
import mekanism.common.capabilities.resolver.advanced.AdvancedCapabilityResolver;
import mekanism.common.content.network.FluidNetwork;
import mekanism.common.content.network.transmitter.MechanicalPipe;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileEntityMechanicalPipe
extends TileEntityTransmitter {
    public TileEntityMechanicalPipe(IBlockProvider blockProvider) {
        super(blockProvider);
        MechanicalPipe handler = this.getTransmitter();
        this.addCapabilityResolver(AdvancedCapabilityResolver.readOnly(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, handler, () -> new ProxyFluidHandler(handler, null, null)));
    }

    protected MechanicalPipe createTransmitter(IBlockProvider blockProvider) {
        return new MechanicalPipe(blockProvider, this);
    }

    public MechanicalPipe getTransmitter() {
        return (MechanicalPipe)super.getTransmitter();
    }

    @Override
    public void func_73660_a() {
        if (!this.isRemote()) {
            this.getTransmitter().pullFromAcceptors();
        }
        super.func_73660_a();
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.MECHANICAL_PIPE;
    }

    @Override
    @Nonnull
    protected BlockState upgradeResult(@Nonnull BlockState current, @Nonnull BaseTier tier) {
        switch (tier) {
            case BASIC: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.BASIC_MECHANICAL_PIPE.getBlock().func_176223_P());
            }
            case ADVANCED: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ADVANCED_MECHANICAL_PIPE.getBlock().func_176223_P());
            }
            case ELITE: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ELITE_MECHANICAL_PIPE.getBlock().func_176223_P());
            }
            case ULTIMATE: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ULTIMATE_MECHANICAL_PIPE.getBlock().func_176223_P());
            }
        }
        return current;
    }

    @Override
    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT updateTag = super.func_189517_E_();
        if (this.getTransmitter().hasTransmitterNetwork()) {
            FluidNetwork network = (FluidNetwork)this.getTransmitter().getTransmitterNetwork();
            updateTag.func_218657_a("fluid", (INBT)network.lastFluid.writeToNBT(new CompoundNBT()));
            updateTag.func_74776_a("scale", network.currentScale);
        }
        return updateTag;
    }
}

