/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import javax.annotation.Nonnull;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.tier.BaseTier;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.chemical.transmitter.ChemicalTransmitterWrapper;
import mekanism.common.capabilities.proxy.ProxyChemicalHandler;
import mekanism.common.capabilities.resolver.advanced.AdvancedCapabilityResolver;
import mekanism.common.content.network.BoxedChemicalNetwork;
import mekanism.common.content.network.transmitter.BoxedPressurizedTube;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class TileEntityPressurizedTube
extends TileEntityTransmitter {
    public TileEntityPressurizedTube(IBlockProvider blockProvider) {
        super(blockProvider);
        BoxedPressurizedTube tube = this.getTransmitter();
        ChemicalTransmitterWrapper.GasTransmitterWrapper gasHandler = new ChemicalTransmitterWrapper.GasTransmitterWrapper(tube, tube::getGasTanks);
        ChemicalTransmitterWrapper.InfusionTransmitterWrapper infusionHandler = new ChemicalTransmitterWrapper.InfusionTransmitterWrapper(tube, tube::getInfusionTanks);
        ChemicalTransmitterWrapper.PigmentTransmitterWrapper pigmentHandler = new ChemicalTransmitterWrapper.PigmentTransmitterWrapper(tube, tube::getPigmentTanks);
        ChemicalTransmitterWrapper.SlurryTransmitterWrapper slurryHandler = new ChemicalTransmitterWrapper.SlurryTransmitterWrapper(tube, tube::getSlurryTanks);
        this.addCapabilityResolver(AdvancedCapabilityResolver.readOnly(Capabilities.GAS_HANDLER_CAPABILITY, gasHandler, () -> new ProxyChemicalHandler.ProxyGasHandler(gasHandler, null, null)));
        this.addCapabilityResolver(AdvancedCapabilityResolver.readOnly(Capabilities.INFUSION_HANDLER_CAPABILITY, infusionHandler, () -> new ProxyChemicalHandler.ProxyInfusionHandler(infusionHandler, null, null)));
        this.addCapabilityResolver(AdvancedCapabilityResolver.readOnly(Capabilities.PIGMENT_HANDLER_CAPABILITY, pigmentHandler, () -> new ProxyChemicalHandler.ProxyPigmentHandler(pigmentHandler, null, null)));
        this.addCapabilityResolver(AdvancedCapabilityResolver.readOnly(Capabilities.SLURRY_HANDLER_CAPABILITY, slurryHandler, () -> new ProxyChemicalHandler.ProxySlurryHandler(slurryHandler, null, null)));
    }

    protected BoxedPressurizedTube createTransmitter(IBlockProvider blockProvider) {
        return new BoxedPressurizedTube(blockProvider, this);
    }

    public BoxedPressurizedTube getTransmitter() {
        return (BoxedPressurizedTube)super.getTransmitter();
    }

    @Override
    public void func_73660_a() {
        if (!this.isRemote()) {
            this.getTransmitter().pullFromAcceptors();
        }
        super.func_73660_a();
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.PRESSURIZED_TUBE;
    }

    @Override
    @Nonnull
    protected BlockState upgradeResult(@Nonnull BlockState current, @Nonnull BaseTier tier) {
        switch (tier) {
            case BASIC: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.BASIC_PRESSURIZED_TUBE.getBlock().func_176223_P());
            }
            case ADVANCED: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ADVANCED_PRESSURIZED_TUBE.getBlock().func_176223_P());
            }
            case ELITE: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ELITE_PRESSURIZED_TUBE.getBlock().func_176223_P());
            }
            case ULTIMATE: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ULTIMATE_PRESSURIZED_TUBE.getBlock().func_176223_P());
            }
        }
        return current;
    }

    @Override
    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT updateTag = super.func_189517_E_();
        if (this.getTransmitter().hasTransmitterNetwork()) {
            BoxedChemicalNetwork network = (BoxedChemicalNetwork)this.getTransmitter().getTransmitterNetwork();
            updateTag.func_218657_a("boxedChemical", (INBT)network.lastChemical.write(new CompoundNBT()));
            updateTag.func_74776_a("scale", network.currentScale);
        }
        return updateTag;
    }
}

