/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import javax.annotation.Nonnull;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.tier.BaseTier;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.capabilities.resolver.advanced.AdvancedEnergyCapabilityResolver;
import mekanism.common.content.network.EnergyNetwork;
import mekanism.common.content.network.transmitter.UniversalCable;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;

public class TileEntityUniversalCable
extends TileEntityTransmitter {
    public TileEntityUniversalCable(IBlockProvider blockProvider) {
        super(blockProvider);
        this.addCapabilityResolver(new AdvancedEnergyCapabilityResolver(this.getTransmitter()));
    }

    protected UniversalCable createTransmitter(IBlockProvider blockProvider) {
        return new UniversalCable(blockProvider, this);
    }

    public UniversalCable getTransmitter() {
        return (UniversalCable)super.getTransmitter();
    }

    @Override
    public void func_73660_a() {
        if (!this.isRemote()) {
            this.getTransmitter().pullFromAcceptors();
        }
        super.func_73660_a();
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.UNIVERSAL_CABLE;
    }

    @Override
    @Nonnull
    protected BlockState upgradeResult(@Nonnull BlockState current, @Nonnull BaseTier tier) {
        switch (tier) {
            case BASIC: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.BASIC_UNIVERSAL_CABLE.getBlock().func_176223_P());
            }
            case ADVANCED: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ADVANCED_UNIVERSAL_CABLE.getBlock().func_176223_P());
            }
            case ELITE: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ELITE_UNIVERSAL_CABLE.getBlock().func_176223_P());
            }
            case ULTIMATE: {
                return BlockStateHelper.copyStateData(current, MekanismBlocks.ULTIMATE_UNIVERSAL_CABLE.getBlock().func_176223_P());
            }
        }
        return current;
    }

    @Override
    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT updateTag = super.func_189517_E_();
        if (this.getTransmitter().hasTransmitterNetwork()) {
            EnergyNetwork network = (EnergyNetwork)this.getTransmitter().getTransmitterNetwork();
            updateTag.func_74778_a("energy", network.energyContainer.getEnergy().toString());
            updateTag.func_74776_a("scale", network.currentScale);
        }
        return updateTag;
    }
}

