/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.widgets.EventRepeater;
import appeng.client.gui.widgets.IScrollSource;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.time.Duration;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class Scrollbar
extends AbstractGui
implements IScrollSource {
    private static final int HANDLE_WIDTH = 12;
    private static final int HANDLE_HEIGHT = 15;
    private static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "textures/gui/container/creative_inventory/tabs.png");
    private static final Rectangle2d ENABLED = new Rectangle2d(232, 0, 12, 15);
    private static final Rectangle2d DISABLED = new Rectangle2d(244, 0, 12, 15);
    private int displayX = 0;
    private int displayY = 0;
    private int width = 12;
    private int height = 16;
    private int pageSize = 1;
    private int maxScroll = 0;
    private int minScroll = 0;
    private int currentScroll = 0;
    private boolean dragging;
    private int dragYOffset;
    private final EventRepeater eventRepeater = new EventRepeater(Duration.ofMillis(250L), Duration.ofMillis(150L));

    public void draw(MatrixStack matrices, AEBaseScreen<?> g) {
        Rectangle2d sourceRect;
        int yOffset;
        this.func_230926_e_(g.func_230927_p_());
        g.bindTexture(TEXTURE);
        if (this.getRange() == 0) {
            yOffset = 0;
            sourceRect = DISABLED;
        } else {
            yOffset = this.getHandleYOffset();
            sourceRect = ENABLED;
        }
        this.func_238474_b_(matrices, this.displayX, this.displayY + yOffset, sourceRect.func_199318_a(), sourceRect.func_199319_b(), sourceRect.func_199316_c(), sourceRect.func_199317_d());
    }

    private int getHandleYOffset() {
        if (this.getRange() == 0) {
            return 0;
        }
        int availableHeight = this.height - 15;
        return (this.currentScroll - this.minScroll) * availableHeight / this.getRange();
    }

    private int getRange() {
        return this.maxScroll - this.minScroll;
    }

    public int getLeft() {
        return this.displayX;
    }

    public Scrollbar setLeft(int v) {
        this.displayX = v;
        return this;
    }

    public int getTop() {
        return this.displayY;
    }

    public Scrollbar setTop(int v) {
        this.displayY = v;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public Scrollbar setWidth(int v) {
        this.width = v;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public Scrollbar setHeight(int v) {
        this.height = v;
        return this;
    }

    public void setRange(int min, int max, int pageSize) {
        this.minScroll = min;
        this.maxScroll = max;
        this.pageSize = pageSize;
        if (this.minScroll > this.maxScroll) {
            this.maxScroll = this.minScroll;
        }
        this.applyRange();
    }

    private void applyRange() {
        this.currentScroll = Math.max(Math.min(this.currentScroll, this.maxScroll), this.minScroll);
    }

    @Override
    public int getCurrentScroll() {
        return this.currentScroll;
    }

    public boolean mouseDown(double x, double y) {
        this.dragging = false;
        if (x < (double)this.displayX || x >= (double)(this.displayX + this.width)) {
            return false;
        }
        int relY = (int)Math.round(y - (double)this.displayY);
        if (relY < 0 || relY >= this.height) {
            return false;
        }
        if (this.getRange() == 0) {
            return true;
        }
        int handleYOffset = this.getHandleYOffset();
        if (relY < handleYOffset) {
            this.pageUp();
            this.eventRepeater.repeat(this::pageUp);
        } else if (relY < handleYOffset + 15) {
            this.dragging = true;
            this.dragYOffset = relY - handleYOffset;
        } else {
            this.pageDown();
            this.eventRepeater.repeat(this::pageDown);
        }
        return true;
    }

    public boolean mouseUp(double x, double y) {
        this.dragging = false;
        this.eventRepeater.stop();
        return false;
    }

    public void mouseDragged(double x, double y) {
        if (this.getRange() == 0 || !this.dragging || this.eventRepeater.isRepeating()) {
            return;
        }
        double handleUpperEdgeY = y - (double)this.displayY - (double)this.dragYOffset;
        double availableHeight = this.height - 15;
        double position = MathHelper.func_151237_a((double)(handleUpperEdgeY / availableHeight), (double)0.0, (double)1.0);
        this.currentScroll = this.minScroll + (int)Math.round(position * (double)this.getRange());
        this.applyRange();
    }

    public void wheel(double delta) {
        if (this.getRange() == 0) {
            return;
        }
        delta = Math.max(Math.min(-delta, 1.0), -1.0);
        this.currentScroll = (int)((double)this.currentScroll + delta * (double)this.pageSize);
        this.applyRange();
    }

    public void tick() {
        this.eventRepeater.tick();
    }

    private void pageUp() {
        this.currentScroll -= this.pageSize;
        this.applyRange();
    }

    private void pageDown() {
        this.currentScroll += this.pageSize;
        this.applyRange();
    }
}

