/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.gui.widgets.ITooltip;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class ToggleButton
extends Button
implements ITooltip {
    public static final ResourceLocation TEXTURE_STATES = new ResourceLocation("appliedenergistics2", "textures/guis/states.png");
    private static final Pattern PATTERN_NEW_LINE = Pattern.compile("\\n", 16);
    private final int iconIdxOn;
    private final int iconIdxOff;
    private final String displayName;
    private final String displayHint;
    private boolean isActive;

    public ToggleButton(int x, int y, int on, int off, String displayName, String displayHint, Button.IPressable onPress) {
        super(x, y, 16, 16, StringTextComponent.field_240750_d_, onPress);
        this.iconIdxOn = on;
        this.iconIdxOff = off;
        this.displayName = displayName;
        this.displayHint = displayHint;
    }

    public void setState(boolean isOn) {
        this.isActive = isOn;
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partial) {
        if (this.field_230694_p_) {
            int iconIndex = this.getIconIndex();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE_STATES);
            int uv_y = iconIndex / 16;
            int uv_x = iconIndex - uv_y * 16;
            GuiUtils.drawTexturedModalRect((int)this.field_230690_l_, (int)this.field_230691_m_, (int)240, (int)240, (int)16, (int)16, (float)0.0f);
            GuiUtils.drawTexturedModalRect((int)this.field_230690_l_, (int)this.field_230691_m_, (int)(uv_x * 16), (int)(uv_y * 16), (int)16, (int)16, (float)0.0f);
        }
    }

    private int getIconIndex() {
        return this.isActive ? this.iconIdxOn : this.iconIdxOff;
    }

    @Override
    public ITextComponent getTooltipMessage() {
        if (this.displayName != null) {
            StringBuilder sb;
            int i;
            String name = I18n.func_135052_a((String)this.displayName, (Object[])new Object[0]);
            String value = I18n.func_135052_a((String)this.displayHint, (Object[])new Object[0]);
            if (name == null || name.isEmpty()) {
                name = this.displayName;
            }
            if (value == null || value.isEmpty()) {
                value = this.displayHint;
            }
            if ((i = (sb = new StringBuilder(value = PATTERN_NEW_LINE.matcher(value).replaceAll("\n"))).lastIndexOf("\n")) <= 0) {
                i = 0;
            }
            while (i + 30 < sb.length() && (i = sb.lastIndexOf(" ", i + 30)) != -1) {
                sb.replace(i, i + 1, "\n");
            }
            return new StringTextComponent(name + '\n' + sb);
        }
        return StringTextComponent.field_240750_d_;
    }

    @Override
    public int getTooltipAreaX() {
        return this.field_230690_l_;
    }

    @Override
    public int getTooltipAreaY() {
        return this.field_230691_m_;
    }

    @Override
    public int getTooltipAreaWidth() {
        return 16;
    }

    @Override
    public int getTooltipAreaHeight() {
        return 16;
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return this.field_230694_p_;
    }
}

