/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.block.storage.DriveSlotsState;
import appeng.client.render.DelegateBakedModel;
import appeng.client.render.model.DriveModelData;
import appeng.client.render.model.MatrixVertexTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public class DriveBakedModel
extends DelegateBakedModel {
    private final Map<Item, IBakedModel> bakedCells;
    private final IBakedModel defaultCell;

    public DriveBakedModel(IBakedModel bakedBase, Map<Item, IBakedModel> cellModels, IBakedModel defaultCell) {
        super(bakedBase);
        this.bakedCells = cellModels;
        this.defaultCell = defaultCell;
    }

    public static void getSlotOrigin(int row, int col, Vector3f translation) {
        float xOffset = (float)(9 - col * 8) / 16.0f;
        float yOffset = (float)(13 - row * 3) / 16.0f;
        float zOffset = 0.0625f;
        translation.func_195905_a(xOffset, yOffset, zOffset);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>(super.getQuads(state, side, rand, extraData));
        if (!(extraData instanceof DriveModelData)) {
            return result;
        }
        DriveModelData driveModelData = (DriveModelData)extraData;
        DriveSlotsState slotsState = driveModelData.getSlotsState();
        Vector3f slotTranslation = new Vector3f();
        if (slotsState != null) {
            for (int row = 0; row < 5; ++row) {
                for (int col = 0; col < 2; ++col) {
                    Matrix4f transform = new Matrix4f();
                    DriveBakedModel.getSlotOrigin(row, col, slotTranslation);
                    transform.setTranslation(slotTranslation.func_195899_a(), slotTranslation.func_195900_b(), slotTranslation.func_195902_c());
                    int slot = row * 2 + col;
                    Item cell = slotsState.getCell(slot);
                    IBakedModel cellChassisModel = this.getCellChassisModel(cell);
                    DriveBakedModel.addModel(state, rand, extraData, result, side, cellChassisModel, transform);
                }
            }
        }
        return result;
    }

    @Override
    public boolean func_177555_b() {
        return false;
    }

    public IBakedModel getCellChassisModel(Item cell) {
        if (cell == null) {
            return this.bakedCells.get(Items.field_190931_a);
        }
        IBakedModel model = this.bakedCells.get(cell);
        return model != null ? model : this.defaultCell;
    }

    private static void addModel(@Nullable BlockState state, @Nonnull Random rand, @Nonnull IModelData extraData, List<BakedQuad> result, Direction side, IBakedModel bakedCell, Matrix4f transform) {
        MatrixVertexTransformer transformer = new MatrixVertexTransformer(transform);
        for (BakedQuad bakedQuad : bakedCell.getQuads(state, side, rand, extraData)) {
            BakedQuadBuilder builder = new BakedQuadBuilder();
            transformer.setParent((IVertexConsumer)builder);
            transformer.setVertexFormat(builder.getVertexFormat());
            bakedQuad.pipe((IVertexConsumer)transformer);
            result.add(builder.build());
        }
    }
}

