/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.client.render.model.MatrixVertexTransformer;
import appeng.hooks.CompassManager;
import appeng.hooks.CompassResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public class SkyCompassBakedModel
implements IDynamicBakedModel {
    public static final ModelProperty<Float> ROTATION = new ModelProperty();
    private final IBakedModel base;
    private final IBakedModel pointer;
    private float fallbackRotation = 0.0f;

    public SkyCompassBakedModel(IBakedModel base, IBakedModel pointer) {
        this.base = base;
        this.pointer = pointer;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData) {
        float rotation = 0.0f;
        Float rotationFromData = (Float)extraData.getData(ROTATION);
        rotation = rotationFromData != null ? rotationFromData.floatValue() : this.fallbackRotation;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        quads.addAll(this.base.getQuads(state, side, rand, extraData));
        if (side == null) {
            Matrix4f matrix = new Matrix4f();
            matrix.func_226591_a_();
            matrix.func_226596_a_(new Quaternion(0.0f, rotation, 0.0f, false));
            MatrixVertexTransformer transformer = new MatrixVertexTransformer(matrix);
            for (BakedQuad bakedQuad : this.pointer.getQuads(state, side, rand, extraData)) {
                BakedQuadBuilder builder = new BakedQuadBuilder();
                transformer.setParent((IVertexConsumer)builder);
                transformer.setVertexFormat(builder.getVertexFormat());
                bakedQuad.pipe((IVertexConsumer)transformer);
                BakedQuad q = builder.build();
                quads.add(q);
            }
        }
        return quads;
    }

    public boolean func_177555_b() {
        return this.base.func_177555_b();
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.base.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.base.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return new ItemOverrideList(){

            public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
                if (world != null && entity instanceof ClientPlayerEntity) {
                    PlayerEntity player = (PlayerEntity)entity;
                    float offRads = (float)((double)(player.field_70177_z / 180.0f * (float)Math.PI) + Math.PI);
                    SkyCompassBakedModel.this.fallbackRotation = offRads + SkyCompassBakedModel.getAnimatedRotation(player.func_233580_cy_(), true);
                } else {
                    SkyCompassBakedModel.this.fallbackRotation = SkyCompassBakedModel.getAnimatedRotation(null, false);
                }
                return originalModel;
            }
        };
    }

    public static float getAnimatedRotation(@Nullable BlockPos pos, boolean prefetch) {
        if (pos != null) {
            CompassResult cr = CompassManager.INSTANCE.getCompassDirection(0L, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            if (prefetch) {
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        CompassManager.INSTANCE.getCompassDirection(0L, pos.func_177958_n() + i - 1, pos.func_177956_o(), pos.func_177952_p() + j - 1);
                    }
                }
            }
            if (cr.isValidResult()) {
                if (cr.isSpin()) {
                    long timeMillis = System.currentTimeMillis();
                    return (float)(timeMillis %= 500L) / 500.0f * (float)Math.PI * 2.0f;
                }
                return (float)cr.getRad();
            }
        }
        long timeMillis = System.currentTimeMillis();
        return (float)(timeMillis %= 3000L) / 3000.0f * (float)Math.PI * 2.0f;
    }
}

