/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerLocator;
import appeng.container.implementations.ContainerHelper;
import appeng.container.slot.InaccessibleSlot;
import appeng.me.helpers.PlayerSource;
import appeng.tile.inventory.AppEngInternalInventory;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class CraftAmountContainer
extends AEBaseContainer {
    public static ContainerType<CraftAmountContainer> TYPE;
    private static final ContainerHelper<CraftAmountContainer, ITerminalHost> helper;
    private final Slot craftingItem = new InaccessibleSlot((IItemHandler)new AppEngInternalInventory(null, 1), 0, 34, 53);
    private IAEItemStack itemToCreate;

    public CraftAmountContainer(int id, PlayerInventory ip, ITerminalHost te) {
        super(TYPE, id, ip, te);
        this.func_75146_a(this.getCraftingItem());
    }

    public static CraftAmountContainer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(PlayerEntity player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        this.verifyPermissions(SecurityPermissions.CRAFT, false);
    }

    public IGrid getGrid() {
        IActionHost h = (IActionHost)this.getTarget();
        return h.getActionableNode().getGrid();
    }

    public World getWorld() {
        return this.getPlayerInv().field_70458_d.field_70170_p;
    }

    public IActionSource getActionSrc() {
        return new PlayerSource(this.getPlayerInv().field_70458_d, (IActionHost)this.getTarget());
    }

    public Slot getCraftingItem() {
        return this.craftingItem;
    }

    public IAEItemStack getItemToCraft() {
        return this.itemToCreate;
    }

    public void setItemToCraft(@Nonnull IAEItemStack itemToCreate) {
        this.itemToCreate = itemToCreate;
    }

    static {
        helper = new ContainerHelper<CraftAmountContainer, ITerminalHost>(CraftAmountContainer::new, ITerminalHost.class, SecurityPermissions.CRAFT);
    }
}

