/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.storage.ITerminalHost;
import appeng.container.ContainerLocator;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerHelper;
import appeng.container.implementations.CraftingCPUContainer;
import appeng.container.implementations.CraftingCPUCycler;
import appeng.container.implementations.CraftingCPUCyclingContainer;
import appeng.container.implementations.CraftingCPURecord;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;

public class CraftingStatusContainer
extends CraftingCPUContainer
implements CraftingCPUCyclingContainer {
    public static ContainerType<CraftingStatusContainer> TYPE;
    private static final ContainerHelper<CraftingStatusContainer, ITerminalHost> helper;
    private final CraftingCPUCycler cpuCycler = new CraftingCPUCycler(this::cpuMatches, this::onCPUSelectionChanged);
    @GuiSync(value=6)
    public boolean noCPU = true;
    @GuiSync(value=7)
    public ITextComponent cpuName;

    public static CraftingStatusContainer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(PlayerEntity player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public CraftingStatusContainer(int id, PlayerInventory ip, ITerminalHost te) {
        super(TYPE, id, ip, te);
    }

    @Override
    public void func_75142_b() {
        IGrid network = this.getNetwork();
        if (this.isServer() && network != null) {
            this.cpuCycler.detectAndSendChanges(network);
        }
        super.func_75142_b();
    }

    private boolean cpuMatches(ICraftingCPU c) {
        return c.isBusy();
    }

    private void onCPUSelectionChanged(CraftingCPURecord cpuRecord, boolean cpusAvailable) {
        boolean bl = this.noCPU = !cpusAvailable;
        if (cpuRecord == null) {
            this.cpuName = null;
            this.setCPU(null);
        } else {
            this.cpuName = cpuRecord.getName();
            this.setCPU(cpuRecord.getCpu());
        }
    }

    @Override
    public void cycleSelectedCPU(boolean forward) {
        this.cpuCycler.cycleCpu(forward);
    }

    static {
        helper = new ContainerHelper<CraftingStatusContainer, ITerminalHost>(CraftingStatusContainer::new, ITerminalHost.class, SecurityPermissions.CRAFT);
    }
}

