/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.guiobjects.IPortableCell;
import appeng.container.ContainerLocator;
import appeng.container.implementations.ContainerHelper;
import appeng.container.implementations.MEMonitorableContainer;
import appeng.container.interfaces.IInventorySlotAware;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class MEPortableCellContainer
extends MEMonitorableContainer {
    public static ContainerType<MEPortableCellContainer> TYPE;
    private static final ContainerHelper<MEPortableCellContainer, IPortableCell> helper;
    private double powerMultiplier = 0.5;
    private final IPortableCell civ;
    private int ticks = 0;
    private final int slot;

    public static MEPortableCellContainer fromNetwork(int windowId, PlayerInventory inv, PacketBuffer buf) {
        return helper.fromNetwork(windowId, inv, buf);
    }

    public static boolean open(PlayerEntity player, ContainerLocator locator) {
        return helper.open(player, locator);
    }

    public MEPortableCellContainer(int id, PlayerInventory ip, IPortableCell monitorable) {
        this(TYPE, id, ip, monitorable);
    }

    protected MEPortableCellContainer(ContainerType<? extends MEPortableCellContainer> type, int id, PlayerInventory ip, IPortableCell monitorable) {
        super(type, id, ip, monitorable, false);
        if (monitorable instanceof IInventorySlotAware) {
            int slotIndex = ((IInventorySlotAware)((Object)monitorable)).getInventorySlot();
            this.lockPlayerInventorySlot(slotIndex);
            this.slot = slotIndex;
        } else {
            this.slot = -1;
            this.lockPlayerInventorySlot(ip.field_70461_c);
        }
        this.civ = monitorable;
        this.bindPlayerInventory(ip, 0, 0);
    }

    @Override
    public void func_75142_b() {
        ItemStack currentItem;
        ItemStack itemStack = currentItem = this.slot < 0 ? this.getPlayerInv().func_70448_g() : this.getPlayerInv().func_70301_a(this.slot);
        if (this.civ == null || currentItem.func_190926_b()) {
            this.setValidContainer(false);
        } else if (this.civ != null && !this.civ.getItemStack().func_190926_b() && currentItem != this.civ.getItemStack()) {
            if (ItemStack.func_179545_c((ItemStack)this.civ.getItemStack(), (ItemStack)currentItem)) {
                this.getPlayerInv().func_70299_a(this.getPlayerInv().field_70461_c, this.civ.getItemStack());
            } else {
                this.setValidContainer(false);
            }
        }
        ++this.ticks;
        if (this.ticks > 10) {
            this.civ.extractAEPower(this.getPowerMultiplier() * (double)this.ticks, Actionable.MODULATE, PowerMultiplier.CONFIG);
            this.ticks = 0;
        }
        super.func_75142_b();
    }

    private double getPowerMultiplier() {
        return this.powerMultiplier;
    }

    void setPowerMultiplier(double powerMultiplier) {
        this.powerMultiplier = powerMultiplier;
    }

    static {
        helper = new ContainerHelper<MEPortableCellContainer, IPortableCell>(MEPortableCellContainer::new, IPortableCell.class);
    }
}

