/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.container.AEBaseContainer;
import appeng.core.AELog;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.util.item.AEItemStack;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public class TargetItemStackPacket
extends BasePacket {
    private AEItemStack stack;

    public TargetItemStackPacket(PacketBuffer stream) {
        try {
            this.stack = stream.readableBytes() > 0 ? AEItemStack.fromPacket(stream) : null;
        }
        catch (Exception ex) {
            AELog.debug(ex);
            this.stack = null;
        }
    }

    public TargetItemStackPacket(AEItemStack stack) {
        this.stack = stack;
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        if (stack != null) {
            try {
                stack.writeToPacket(data);
            }
            catch (Exception ex) {
                AELog.debug(ex);
            }
        }
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, PlayerEntity player) {
        if (player.field_71070_bA instanceof AEBaseContainer) {
            ((AEBaseContainer)player.field_71070_bA).setTargetStack(this.stack);
        }
    }
}

