/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.recipes;

import appeng.api.definitions.IBlockDefinition;
import appeng.datagen.providers.IAE2DataProvider;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.SingleItemRecipeBuilder;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class SlabStairRecipes
extends RecipeProvider
implements IAE2DataProvider {
    IBlockDefinition[][] blocks = new IBlockDefinition[][]{{BLOCKS.skyStoneBlock(), BLOCKS.skyStoneSlab(), BLOCKS.skyStoneStairs()}, {BLOCKS.smoothSkyStoneBlock(), BLOCKS.smoothSkyStoneSlab(), BLOCKS.smoothSkyStoneStairs()}, {BLOCKS.skyStoneBrick(), BLOCKS.skyStoneBrickSlab(), BLOCKS.skyStoneBrickStairs()}, {BLOCKS.skyStoneSmallBrick(), BLOCKS.skyStoneSmallBrickSlab(), BLOCKS.skyStoneSmallBrickStairs()}, {BLOCKS.fluixBlock(), BLOCKS.fluixSlab(), BLOCKS.fluixStairs()}, {BLOCKS.quartzBlock(), BLOCKS.quartzSlab(), BLOCKS.quartzStairs()}, {BLOCKS.chiseledQuartzBlock(), BLOCKS.chiseledQuartzSlab(), BLOCKS.chiseledQuartzStairs()}, {BLOCKS.quartzPillar(), BLOCKS.quartzPillarSlab(), BLOCKS.quartzPillarStairs()}};

    public SlabStairRecipes(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void func_200404_a(@Nonnull Consumer<IFinishedRecipe> consumer) {
        for (IBlockDefinition[] block : this.blocks) {
            this.slabRecipe(consumer, block[0], block[1]);
            this.stairRecipe(consumer, block[0], block[2]);
        }
    }

    private void slabRecipe(Consumer<IFinishedRecipe> consumer, IBlockDefinition block, IBlockDefinition slabs) {
        Block inputBlock = block.block();
        Block outputBlock = slabs.block();
        ShapedRecipeBuilder.func_200468_a((IItemProvider)slabs.block(), (int)6).func_200472_a("###").func_200462_a(Character.valueOf('#'), (IItemProvider)inputBlock).func_200465_a(this.criterionName(block), (ICriterionInstance)SlabStairRecipes.func_200403_a((IItemProvider)inputBlock)).func_200467_a(consumer, new ResourceLocation("appliedenergistics2", "shaped/slabs/" + block.identifier()));
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{inputBlock}), (IItemProvider)outputBlock, (int)2).func_218643_a(this.criterionName(block), (ICriterionInstance)SlabStairRecipes.func_200403_a((IItemProvider)inputBlock)).func_218647_a(consumer, new ResourceLocation("appliedenergistics2", "block_cutter/slabs/" + slabs.identifier()));
    }

    private void stairRecipe(Consumer<IFinishedRecipe> consumer, IBlockDefinition block, IBlockDefinition stairs) {
        Block inputBlock = block.block();
        Block outputBlock = stairs.block();
        ShapedRecipeBuilder.func_200468_a((IItemProvider)outputBlock, (int)4).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200462_a(Character.valueOf('#'), (IItemProvider)inputBlock).func_200465_a(this.criterionName(block), (ICriterionInstance)SlabStairRecipes.func_200403_a((IItemProvider)inputBlock)).func_200467_a(consumer, new ResourceLocation("appliedenergistics2", "shaped/stairs/" + block.identifier()));
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{inputBlock}), (IItemProvider)outputBlock).func_218643_a(this.criterionName(block), (ICriterionInstance)SlabStairRecipes.func_200403_a((IItemProvider)inputBlock)).func_218647_a(consumer, new ResourceLocation("appliedenergistics2", "block_cutter/stairs/" + stairs.identifier()));
    }

    private String criterionName(IBlockDefinition block) {
        return String.format("has_%s", block.identifier());
    }

    public String func_200397_b() {
        return "Applied Energistics 2 Slabs and Stairs";
    }
}

