/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.tags;

import appeng.api.definitions.IBlockDefinition;
import appeng.core.AppEng;
import appeng.datagen.providers.IAE2DataProvider;
import java.nio.file.Path;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.TagsProvider;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

public class BlockTagsProvider
extends net.minecraft.data.BlockTagsProvider
implements IAE2DataProvider {
    public BlockTagsProvider(GatherDataEvent dataEvent) {
        super(dataEvent.getGenerator(), "appliedenergistics2", dataEvent.getExistingFileHelper());
    }

    protected void func_200432_c() {
        this.addForge("ores/certus_quartz", BLOCKS.quartzOre(), BLOCKS.quartzOreCharged());
        this.addForge("ores", "#forge:ores/certus_quartz");
        this.addForge("storage_blocks/certus_quartz", BLOCKS.quartzBlock());
        this.addForge("storage_blocks", "#forge:storage_blocks/certus_quartz");
        this.addForge("terracotta", Blocks.field_150405_ch, Blocks.field_196777_fo, Blocks.field_196778_fp, Blocks.field_196780_fq, Blocks.field_196782_fr, Blocks.field_196783_fs, Blocks.field_196785_ft, Blocks.field_196787_fu, Blocks.field_196789_fv, Blocks.field_196791_fw, Blocks.field_196793_fx, Blocks.field_196795_fy, Blocks.field_196797_fz, Blocks.field_196719_fA, Blocks.field_196720_fB, Blocks.field_196721_fC, Blocks.field_196722_fD);
        this.addAe2("blacklisted/annihilation_plane", Blocks.field_150357_h, Blocks.field_150384_bq, Blocks.field_150378_br, Blocks.field_150483_bI);
        this.addAe2("spatial/blacklist", new Object[0]);
        this.addAe2("spatial/whitelist", new Object[0]);
        this.addAe2("whitelisted/facades", Blocks.field_150359_w, Tags.Blocks.STAINED_GLASS, BLOCKS.quartzGlass(), BLOCKS.quartzVibrantGlass());
    }

    private void addForge(String tagName, Object ... blockSources) {
        this.add(new ResourceLocation("forge", tagName), blockSources);
    }

    private void addAe2(String tagName, Object ... blockSources) {
        this.add(AppEng.makeId(tagName), blockSources);
    }

    private void add(ResourceLocation tagName, Object ... blockSources) {
        TagsProvider.Builder builder = this.func_240522_a_((ITag.INamedTag)BlockTags.createOptional((ResourceLocation)tagName));
        for (Object blockSource : blockSources) {
            if (blockSource instanceof Block) {
                builder.func_240534_a_((Object[])new Block[]{(Block)blockSource});
                continue;
            }
            if (blockSource instanceof IBlockDefinition) {
                builder.func_240534_a_((Object[])new Block[]{((IBlockDefinition)blockSource).block()});
                continue;
            }
            if (blockSource instanceof ITag.INamedTag) {
                builder.func_240531_a_((ITag.INamedTag)blockSource);
                continue;
            }
            if (blockSource instanceof String) {
                String blockSourceString = (String)blockSource;
                if (blockSourceString.startsWith("#")) {
                    builder.add((ITag.ITagEntry)new ITag.TagEntry(new ResourceLocation(blockSourceString.substring(1))));
                    continue;
                }
                builder.add((ITag.ITagEntry)new ITag.ItemEntry(new ResourceLocation(blockSourceString)));
                continue;
            }
            throw new IllegalArgumentException("Unknown block source: " + blockSource);
        }
    }

    protected Path func_200431_a(ResourceLocation id) {
        return this.field_200433_a.func_200391_b().resolve("data/" + id.func_110624_b() + "/tags/blocks/" + id.func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "Applied Energistics 2 Block Tags";
    }
}

