/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.client.gui.widgets;

import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.AEColor;
import appeng.client.gui.widgets.ITooltip;
import appeng.fluids.util.IAEFluidTank;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;

@OnlyIn(value=Dist.CLIENT)
public class FluidTankWidget
extends Widget
implements ITooltip {
    private final IAEFluidTank tank;
    private final int slot;

    public FluidTankWidget(IAEFluidTank tank, int slot, int x, int y, int w, int h) {
        super(x, y, w, h, StringTextComponent.field_240750_d_);
        this.tank = tank;
        this.slot = slot;
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230694_p_) {
            RenderSystem.disableBlend();
            FluidTankWidget.func_238467_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)(AEColor.GRAY.blackVariant | 0xFF000000));
            IAEFluidStack fluidStack = this.tank.getFluidInSlot(this.slot);
            if (fluidStack != null && fluidStack.getStackSize() > 0L) {
                Fluid fluid = fluidStack.getFluid();
                FluidAttributes attributes = fluid.getAttributes();
                float red = (float)(attributes.getColor() >> 16 & 0xFF) / 255.0f;
                float green = (float)(attributes.getColor() >> 8 & 0xFF) / 255.0f;
                float blue = (float)(attributes.getColor() & 0xFF) / 255.0f;
                RenderSystem.color3f((float)red, (float)green, (float)blue);
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
                TextureAtlasSprite sprite = (TextureAtlasSprite)mc.func_228015_a_(AtlasTexture.field_110575_b).apply(attributes.getStillTexture(fluidStack.getFluidStack()));
                int scaledHeight = (int)((float)this.field_230689_k_ * ((float)fluidStack.getStackSize() / (float)this.tank.getTankCapacity(this.slot)));
                int iconHeightRemainder = scaledHeight % 16;
                if (iconHeightRemainder > 0) {
                    FluidTankWidget.func_238470_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)(this.field_230691_m_ + this.field_230689_k_ - iconHeightRemainder), (int)this.func_230927_p_(), (int)16, (int)iconHeightRemainder, (TextureAtlasSprite)sprite);
                }
                for (int i = 0; i < scaledHeight / 16; ++i) {
                    FluidTankWidget.func_238470_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)(this.field_230691_m_ + this.field_230689_k_ - iconHeightRemainder - (i + 1) * 16), (int)this.func_230927_p_(), (int)16, (int)16, (TextureAtlasSprite)sprite);
                }
            }
        }
    }

    @Override
    public ITextComponent getTooltipMessage() {
        IAEFluidStack fluid = this.tank.getFluidInSlot(this.slot);
        if (fluid != null && fluid.getStackSize() > 0L) {
            return fluid.getFluid().getAttributes().getDisplayName(fluid.getFluidStack()).func_230532_e_().func_240702_b_("\n" + fluid.getStackSize() + "mB");
        }
        return StringTextComponent.field_240750_d_;
    }

    @Override
    public int getTooltipAreaX() {
        return this.field_230690_l_ - 2;
    }

    @Override
    public int getTooltipAreaY() {
        return this.field_230691_m_ - 2;
    }

    @Override
    public int getTooltipAreaWidth() {
        return this.field_230688_j_ + 4;
    }

    @Override
    public int getTooltipAreaHeight() {
        return this.field_230689_k_ + 4;
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return true;
    }
}

