/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.helper;

import appeng.api.storage.data.IAEFluidStack;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.FluidSlotPacket;
import appeng.fluids.util.AEFluidInventory;
import appeng.fluids.util.IAEFluidTank;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.IContainerListener;

public class FluidSyncHelper {
    private final IAEFluidTank inv;
    private final IAEFluidTank cache;
    private final int idOffset;

    public FluidSyncHelper(IAEFluidTank inv, int idOffset) {
        this.inv = inv;
        this.cache = new AEFluidInventory(null, inv.getSlots());
        this.idOffset = idOffset;
    }

    public void sendFull(Iterable<IContainerListener> listeners) {
        this.sendDiffMap(this.createDiffMap(true), listeners);
    }

    public void sendDiff(Iterable<IContainerListener> listeners) {
        this.sendDiffMap(this.createDiffMap(false), listeners);
    }

    public void readPacket(Map<Integer, IAEFluidStack> data) {
        for (int i = 0; i < this.inv.getSlots(); ++i) {
            if (!data.containsKey(i + this.idOffset)) continue;
            this.inv.setFluidInSlot(i, data.get(i + this.idOffset));
        }
    }

    private void sendDiffMap(Map<Integer, IAEFluidStack> data, Iterable<IContainerListener> listeners) {
        if (data.isEmpty()) {
            return;
        }
        for (IContainerListener l : listeners) {
            if (!(l instanceof ServerPlayerEntity)) continue;
            NetworkHandler.instance().sendTo(new FluidSlotPacket(data), (ServerPlayerEntity)l);
        }
    }

    private final Map<Integer, IAEFluidStack> createDiffMap(boolean full) {
        HashMap<Integer, IAEFluidStack> ret = new HashMap<Integer, IAEFluidStack>();
        for (int i = 0; i < this.inv.getSlots(); ++i) {
            if (full || !this.equalsSlot(i)) {
                ret.put(i + this.idOffset, this.inv.getFluidInSlot(i));
            }
            if (full) continue;
            this.cache.setFluidInSlot(i, this.inv.getFluidInSlot(i));
        }
        return ret;
    }

    private final boolean equalsSlot(int slot) {
        IAEFluidStack stackB;
        IAEFluidStack stackA = this.inv.getFluidInSlot(slot);
        if (!Objects.equals(stackA, stackB = this.cache.getFluidInSlot(slot))) {
            return false;
        }
        return stackA == null || stackA.getStackSize() == stackB.getStackSize();
    }
}

