/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.api.networking.IGridNode;
import appeng.api.parts.CableRenderMode;
import appeng.api.util.AEColor;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.Api;
import appeng.core.AppEng;
import appeng.core.sync.packets.PaintedEntityPacket;
import appeng.crafting.CraftingJob;
import appeng.me.Grid;
import appeng.tile.AEBaseTileEntity;
import appeng.util.IWorldCallable;
import appeng.util.Platform;
import com.google.common.base.Stopwatch;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;

public class TickHandler {
    private static final TickHandler INSTANCE = new TickHandler();
    private final Queue<IWorldCallable<?>> serverQueue = new ArrayDeque();
    private final Multimap<World, CraftingJob> craftingJobs = LinkedListMultimap.create();
    private final Map<IWorld, Queue<IWorldCallable<?>>> callQueue = new WeakHashMap();
    private final HandlerRep server = new HandlerRep();
    private final HandlerRep client = new HandlerRep();
    private final Map<Integer, PlayerColor> cliPlayerColors = new HashMap<Integer, PlayerColor>();
    private final Map<Integer, PlayerColor> srvPlayerColors = new HashMap<Integer, PlayerColor>();
    private CableRenderMode crm = CableRenderMode.STANDARD;

    public static TickHandler instance() {
        return INSTANCE;
    }

    public static void setup(final IEventBus eventBus) {
        eventBus.addListener(INSTANCE::onServerTick);
        eventBus.addListener(INSTANCE::onWorldTick);
        eventBus.addListener(INSTANCE::onUnloadWorld);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> new DistExecutor.SafeRunnable(){
            private static final long serialVersionUID = 5221919736953944125L;

            public void run() {
                eventBus.addListener(INSTANCE::onClientTick);
            }
        });
    }

    public Map<Integer, PlayerColor> getPlayerColors() {
        if (Platform.isServer()) {
            return this.srvPlayerColors;
        }
        return this.cliPlayerColors;
    }

    public void addCallable(IWorld w, IWorldCallable<?> c) {
        if (w == null) {
            this.serverQueue.add(c);
        } else {
            Queue<IWorldCallable<?>> queue = this.callQueue.get(w);
            if (queue == null) {
                queue = new ArrayDeque();
                this.callQueue.put(w, queue);
            }
            queue.add(c);
        }
    }

    public void addInit(AEBaseTileEntity tile) {
        if (Platform.isServer()) {
            this.getRepo().tiles.add(tile);
        }
    }

    private HandlerRep getRepo() {
        if (Platform.isServer()) {
            return this.server;
        }
        return this.client;
    }

    public void addNetwork(Grid grid) {
        if (Platform.isServer()) {
            this.getRepo().addNetwork(grid);
        }
    }

    public void removeNetwork(Grid grid) {
        if (Platform.isServer()) {
            this.getRepo().removeNetwork(grid);
        }
    }

    public Iterable<Grid> getGridList() {
        return this.getRepo().networks;
    }

    public void shutdown() {
        this.getRepo().clear();
    }

    public void onUnloadWorld(WorldEvent.Unload ev) {
        if (Platform.isServer()) {
            ArrayList<IGridNode> toDestroy = new ArrayList<IGridNode>();
            this.getRepo().updateNetworks();
            for (Grid g : this.getRepo().networks) {
                for (IGridNode n : g.getNodes()) {
                    if (n.getWorld() != ev.getWorld()) continue;
                    toDestroy.add(n);
                }
            }
            for (IGridNode n : toDestroy) {
                n.destroy();
            }
        }
    }

    public void onClientTick(TickEvent.ClientTickEvent ev) {
        if (ev.phase == TickEvent.Phase.START) {
            this.tickColors(this.cliPlayerColors);
            CableRenderMode currentMode = Api.instance().partHelper().getCableRenderMode();
            if (currentMode != this.crm) {
                this.crm = currentMode;
                AppEng.proxy.triggerUpdates();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWorldTick(TickEvent.WorldTickEvent ev) {
        if (ev.phase == TickEvent.Phase.START) {
            World world = ev.world;
            Queue<IWorldCallable<?>> queue = this.callQueue.get(world);
            this.processQueue(queue, world);
        }
        if (ev.phase == TickEvent.Phase.END) {
            Multimap<World, CraftingJob> multimap = this.craftingJobs;
            synchronized (multimap) {
                Collection jobSet = this.craftingJobs.get((Object)ev.world);
                if (!jobSet.isEmpty()) {
                    int jobSize = jobSet.size();
                    int microSecondsPerTick = AEConfig.instance().getCraftingCalculationTimePerTick() * 1000;
                    int simTime = Math.max(1, microSecondsPerTick / jobSize);
                    Iterator i = jobSet.iterator();
                    while (i.hasNext()) {
                        CraftingJob cj = (CraftingJob)i.next();
                        if (cj.simulateFor(simTime)) continue;
                        i.remove();
                    }
                }
            }
        }
    }

    public void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase == TickEvent.Phase.END) {
            this.tickColors(this.srvPlayerColors);
            ArrayList<AEBaseTileEntity> delayQueue = null;
            HandlerRep repo = this.getRepo();
            while (!repo.tiles.isEmpty()) {
                AEBaseTileEntity bt = (AEBaseTileEntity)repo.tiles.poll();
                if (bt.func_145837_r()) continue;
                AbstractChunkProvider chunkProvider = bt.func_145831_w().func_72863_F();
                if (chunkProvider.func_222866_a(bt.func_174877_v())) {
                    bt.onReady();
                    continue;
                }
                ChunkPos chunkPos = new ChunkPos(bt.func_174877_v());
                if (chunkProvider.func_73149_a(chunkPos.field_77276_a, chunkPos.field_77275_b)) {
                    if (delayQueue == null) {
                        delayQueue = new ArrayList<AEBaseTileEntity>();
                    }
                    delayQueue.add(bt);
                    continue;
                }
                AELog.warn("Skipping onReady for Tile-Entity in unloaded chunk %s", chunkPos);
            }
            if (delayQueue != null) {
                AELog.debug("Delaying onReady for %s tile-entities because their chunks are not fully loaded", delayQueue.size());
                repo.tiles.addAll(delayQueue);
            }
            this.getRepo().updateNetworks();
            for (Grid g : this.getRepo().networks) {
                g.update();
            }
            this.processQueue(this.serverQueue, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCraftingSimulation(World world, CraftingJob craftingJob) {
        Multimap<World, CraftingJob> multimap = this.craftingJobs;
        synchronized (multimap) {
            this.craftingJobs.put((Object)world, (Object)craftingJob);
        }
    }

    private void tickColors(Map<Integer, PlayerColor> playerSet) {
        Iterator<PlayerColor> i = playerSet.values().iterator();
        while (i.hasNext()) {
            PlayerColor pc = i.next();
            if (pc.ticksLeft <= 0) {
                i.remove();
            }
            pc.ticksLeft--;
        }
    }

    private void processQueue(Queue<IWorldCallable<?>> queue, World world) {
        if (queue == null) {
            return;
        }
        Stopwatch sw = Stopwatch.createStarted();
        IWorldCallable<?> c = null;
        while ((c = queue.poll()) != null) {
            try {
                c.call(world);
                if (sw.elapsed(TimeUnit.MILLISECONDS) <= 50L) continue;
                break;
            }
            catch (Exception e) {
                AELog.debug(e);
            }
        }
    }

    public static class PlayerColor {
        public final AEColor myColor;
        private final int myEntity;
        private int ticksLeft;

        public PlayerColor(int id, AEColor col, int ticks) {
            this.myEntity = id;
            this.myColor = col;
            this.ticksLeft = ticks;
        }

        public PaintedEntityPacket getPacket() {
            return new PaintedEntityPacket(this.myEntity, this.myColor, this.ticksLeft);
        }
    }

    private static class HandlerRep {
        private Queue<AEBaseTileEntity> tiles = new ArrayDeque<AEBaseTileEntity>();
        private Set<Grid> networks = new HashSet<Grid>();
        private Set<Grid> toAdd = new HashSet<Grid>();
        private Set<Grid> toRemove = new HashSet<Grid>();

        private HandlerRep() {
        }

        private void clear() {
            this.tiles = new ArrayDeque<AEBaseTileEntity>();
            this.networks = new HashSet<Grid>();
            this.toAdd = new HashSet<Grid>();
            this.toRemove = new HashSet<Grid>();
        }

        private synchronized void addNetwork(Grid g) {
            this.toAdd.add(g);
            this.toRemove.remove(g);
        }

        private synchronized void removeNetwork(Grid g) {
            this.toRemove.add(g);
            this.toAdd.remove(g);
        }

        private synchronized void updateNetworks() {
            this.networks.removeAll(this.toRemove);
            this.toRemove.clear();
            this.networks.addAll(this.toAdd);
            this.toAdd.clear();
        }
    }
}

