/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.core.settings.TickRates;
import appeng.me.GridAccessException;
import appeng.tile.grid.AENetworkInvTileEntity;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperFilteredItemHandler;
import appeng.util.inv.filter.IAEItemFilter;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;

public class VibrationChamberTileEntity
extends AENetworkInvTileEntity
implements IGridTickable {
    public static final double POWER_PER_TICK = 5.0;
    public static final int MIN_BURN_SPEED = 20;
    public static final int MAX_BURN_SPEED = 200;
    public static final double DILATION_SCALING = 25.0;
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 1);
    private final IItemHandler invExt = new WrapperFilteredItemHandler((IItemHandler)this.inv, new FuelSlotFilter());
    private int burnSpeed = 100;
    private double burnTime = 0.0;
    private double maxBurnTime = 0.0;
    public boolean isOn;

    public VibrationChamberTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.getProxy().setIdlePowerUsage(0.0);
        this.getProxy().setFlags(new GridFlags[0]);
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.COVERED;
    }

    @Override
    protected boolean readFromStream(PacketBuffer data) throws IOException {
        boolean c = super.readFromStream(data);
        boolean wasOn = this.isOn;
        this.isOn = data.readBoolean();
        return wasOn != this.isOn || c;
    }

    @Override
    protected void writeToStream(PacketBuffer data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.getBurnTime() > 0.0);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT data) {
        super.func_189515_b(data);
        data.func_74780_a("burnTime", this.getBurnTime());
        data.func_74780_a("maxBurnTime", this.getMaxBurnTime());
        data.func_74768_a("burnSpeed", this.getBurnSpeed());
        return data;
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT data) {
        super.func_230337_a_(blockState, data);
        this.setBurnTime(data.func_74769_h("burnTime"));
        this.setMaxBurnTime(data.func_74769_h("maxBurnTime"));
        this.setBurnSpeed(data.func_74762_e("burnSpeed"));
    }

    @Override
    protected IItemHandler getItemHandlerForSide(@Nonnull Direction facing) {
        return this.invExt;
    }

    @Override
    public IItemHandler getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.getBurnTime() <= 0.0 && this.canEatFuel()) {
            try {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    private boolean canEatFuel() {
        int newBurnTime;
        ItemStack is = this.inv.getStackInSlot(0);
        return !is.func_190926_b() && (newBurnTime = ForgeHooks.getBurnTime((ItemStack)is)) > 0 && is.func_190916_E() > 0;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        if (this.getBurnTime() <= 0.0) {
            this.eatFuel();
        }
        return new TickingRequest(TickRates.VibrationChamber.getMin(), TickRates.VibrationChamber.getMax(), this.getBurnTime() <= 0.0, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.getBurnTime() <= 0.0) {
            this.eatFuel();
            if (this.getBurnTime() > 0.0) {
                return TickRateModulation.URGENT;
            }
            this.setBurnSpeed(100);
            return TickRateModulation.SLEEP;
        }
        this.setBurnSpeed(Math.max(20, Math.min(this.getBurnSpeed(), 200)));
        double dilation = (double)this.getBurnSpeed() / 25.0;
        double timePassed = (double)ticksSinceLastCall * dilation;
        this.setBurnTime(this.getBurnTime() - timePassed);
        if (this.getBurnTime() < 0.0) {
            timePassed += this.getBurnTime();
            this.setBurnTime(0.0);
        }
        try {
            IEnergyGrid grid = this.getProxy().getEnergy();
            double newPower = timePassed * 5.0;
            double overFlow = grid.injectPower(newPower, Actionable.SIMULATE);
            grid.injectPower(Math.max(0.0, newPower - overFlow), Actionable.MODULATE);
            if (overFlow > 0.0) {
                this.setBurnSpeed(this.getBurnSpeed() - ticksSinceLastCall);
            } else {
                this.setBurnSpeed(this.getBurnSpeed() + ticksSinceLastCall);
            }
            this.setBurnSpeed(Math.max(20, Math.min(this.getBurnSpeed(), 200)));
            return overFlow > 0.0 ? TickRateModulation.SLOWER : TickRateModulation.FASTER;
        }
        catch (GridAccessException e) {
            this.setBurnSpeed(this.getBurnSpeed() - ticksSinceLastCall);
            this.setBurnSpeed(Math.max(20, Math.min(this.getBurnSpeed(), 200)));
            return TickRateModulation.SLOWER;
        }
    }

    private void eatFuel() {
        int newBurnTime;
        ItemStack is = this.inv.getStackInSlot(0);
        if (!is.func_190926_b() && (newBurnTime = ForgeHooks.getBurnTime((ItemStack)is)) > 0 && is.func_190916_E() > 0) {
            this.setBurnTime(this.getBurnTime() + (double)newBurnTime);
            this.setMaxBurnTime(this.getBurnTime());
            Item fuelItem = is.func_77973_b();
            is.func_190918_g(1);
            if (is.func_190926_b()) {
                this.inv.setStackInSlot(0, fuelItem.getContainerItem(is));
            } else {
                this.inv.setStackInSlot(0, is);
            }
            this.saveChanges();
        }
        if (this.getBurnTime() > 0.0) {
            try {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if (!this.isOn && this.getBurnTime() > 0.0 || this.isOn && this.getBurnTime() <= 0.0) {
            this.isOn = this.getBurnTime() > 0.0;
            this.markForUpdate();
            if (this.func_145830_o()) {
                Platform.notifyBlocksOfNeighbors(this.field_145850_b, this.field_174879_c);
            }
        }
    }

    public int getBurnSpeed() {
        return this.burnSpeed;
    }

    private void setBurnSpeed(int burnSpeed) {
        this.burnSpeed = burnSpeed;
    }

    public double getMaxBurnTime() {
        return this.maxBurnTime;
    }

    private void setMaxBurnTime(double maxBurnTime) {
        this.maxBurnTime = maxBurnTime;
    }

    public double getBurnTime() {
        return this.burnTime;
    }

    private void setBurnTime(double burnTime) {
        this.burnTime = burnTime;
    }

    private class FuelSlotFilter
    implements IAEItemFilter {
        private FuelSlotFilter() {
        }

        @Override
        public boolean allowExtract(IItemHandler inv, int slot, int amount) {
            return ForgeHooks.getBurnTime((ItemStack)inv.getStackInSlot(slot)) == 0;
        }

        @Override
        public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
            return ForgeHooks.getBurnTime((ItemStack)stack) != 0;
        }
    }
}

