/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.storage;

import appeng.block.storage.SkyChestBlock;
import appeng.tile.AEBaseInvTileEntity;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.inv.InvOperation;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;

@OnlyIn(value=Dist.CLIENT, _interface=IChestLid.class)
public class SkyChestTileEntity
extends AEBaseInvTileEntity
implements ITickableTileEntity,
IChestLid {
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 36);
    private int numPlayersUsing;
    private long lastEvent;
    private float lidAngle;
    private float prevLidAngle;

    public SkyChestTileEntity(TileEntityType<? extends SkyChestTileEntity> type) {
        super(type);
    }

    @Override
    protected void writeToStream(PacketBuffer data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.getPlayerOpen() > 0);
    }

    @Override
    protected boolean readFromStream(PacketBuffer data) throws IOException {
        boolean c = super.readFromStream(data);
        int wasOpen = this.getPlayerOpen();
        this.setPlayerOpen(data.readBoolean() ? 1 : 0);
        if (wasOpen != this.getPlayerOpen()) {
            this.setLastEvent(System.currentTimeMillis());
        }
        return c;
    }

    @Override
    public IItemHandler getInternalInventory() {
        return this.inv;
    }

    public void openInventory(PlayerEntity player) {
        if (!player.func_175149_v()) {
            this.setPlayerOpen(this.getPlayerOpen() + 1);
            this.onOpenOrClose();
            if (this.getPlayerOpen() == 1) {
                this.func_145831_w().func_184148_a(player, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f);
                this.markForUpdate();
            }
        }
    }

    public void closeInventory(PlayerEntity player) {
        if (!player.func_175149_v()) {
            this.setPlayerOpen(this.getPlayerOpen() - 1);
            this.onOpenOrClose();
            if (this.getPlayerOpen() < 0) {
                this.setPlayerOpen(0);
            }
            if (this.getPlayerOpen() == 0) {
                this.func_145831_w().func_184148_a(player, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f);
                this.markForUpdate();
            }
        }
    }

    private void onOpenOrClose() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof SkyChestBlock) {
            this.field_145850_b.func_175641_c(this.field_174879_c, block, 1, this.numPlayersUsing);
            this.field_145850_b.func_195593_d(this.field_174879_c, block);
            this.field_145850_b.func_195593_d(this.field_174879_c.func_177977_b(), block);
        }
    }

    public void func_73660_a() {
        this.prevLidAngle = this.lidAngle;
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            this.lidAngle = MathHelper.func_76131_a((float)this.lidAngle, (float)0.0f, (float)1.0f);
        }
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
    }

    public int getPlayerOpen() {
        return this.numPlayersUsing;
    }

    private void setPlayerOpen(int playerOpen) {
        this.numPlayersUsing = playerOpen;
    }

    public long getLastEvent() {
        return this.lastEvent;
    }

    private void setLastEvent(long lastEvent) {
        this.lastEvent = lastEvent;
    }

    public float func_195480_a(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevLidAngle, (float)this.lidAngle);
    }
}

