/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import appeng.util.item.AESharedItemStack;
import appeng.util.item.AbstractItemList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

class FuzzyItemList
extends AbstractItemList {
    private final NavigableMap<AESharedItemStack, IAEItemStack> records = new TreeMap<AESharedItemStack, IAEItemStack>();

    FuzzyItemList() {
    }

    @Override
    public Collection<IAEItemStack> findFuzzy(IAEItemStack filter, FuzzyMode fuzzy) {
        if (filter == null) {
            return Collections.emptyList();
        }
        return this.findFuzzyDamage(filter, fuzzy);
    }

    @Override
    Map<AESharedItemStack, IAEItemStack> getRecords() {
        return this.records;
    }

    private Collection<IAEItemStack> findFuzzyDamage(IAEItemStack filter, FuzzyMode fuzzy) {
        AEItemStack itemStack = (AEItemStack)filter;
        AESharedItemStack.Bounds bounds = itemStack.getSharedStack().getBounds(fuzzy);
        return this.records.subMap(bounds.lower(), true, bounds.upper(), true).descendingMap().values();
    }
}

